<?php
/***************************************************************************
 *                           recviewpage.php
 *
 *                           --------------------
 *   begin                : sunday, 04 february, 2009
 *   owner                : Qumbetlian
 *   email                : qumbetlian@yahoo.com
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is a free script; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   Acest program este un script liber; il puteti redistribui si/sau modifica
 *   sub termenii Licentei Publice Generale asa cum este publicata de
 *   Fundatia Free Software; fie in versiunea a doua a licentei, sau 
 *   (la alegerea dvs.) oricarei versiuni ulterioare.
 *
 ***************************************************************************/

// Script pentru inregistrarea celor mai recent vizitate pagini
// Script for recording of the most recent viewed pages

define("TRACKED_PAGES", 5); // Numarul paginilor inregistrate // Recording page number

// Sesiunea in care stocam adresele
// The session that store the addresses
session_name('RecentlyViewedPages');
session_start();

// Adauga adresa paginii impreuna cu titlul paginii primite ca argument, in lista paginilor recent vizitate
// Add the page address together the page title given as argument, in the most recently viewed page list.
function add2recent($page_URL, $page_title)
{
	$page_position = TRACKED_PAGES;
	for($i = 0; $i < TRACKED_PAGES; $i++)
		if(isset($_SESSION["URL$i"]) && isset($_SESSION["title$i"]))
			if($_SESSION["URL$i"] == $page_URL && $_SESSION["title$i"] == $page_title)
				$page_position = $i;
	for($i = $page_position - 1; $i >= 0; $i--) {
		if(isset($_SESSION["URL$i"]) && isset($_SESSION["title$i"])) {
			$_SESSION['URL'.($i + 1)] = $_SESSION["URL$i"];
			$_SESSION['title'.($i + 1)] = $_SESSION["title$i"];
		}
	}
	$_SESSION['URL0'] = $page_URL;
	$_SESSION['title0'] = $page_title;
}

// Afiseaza lista cu paginile recent vizitate.
// Dispaly the list with recently viewed pages.
function showrecent($how="LINK")
{
	for($i = 0; $i < TRACKED_PAGES; $i++)
		if(isset($_SESSION["URL$i"]) && isset($_SESSION["title$i"]))
			switch($how) {
				case "list":
				case "LIST":
					echo "URL=\"".$_SESSION["URL$i"]."\" title=\"".$_SESSION["title$i"]."\"<br/>";
					break;
				case "link":
				case "LINK":
					echo '<a href="'.$_SESSION["URL$i"].'">'.$_SESSION["title$i"].'</a><br/>';
					break;
				default :
					echo "Use showrecent('LINK') or showrecent('LIST') to specify how to display";
			}
}

?>
