/***************************************************************
 * Name:      qcopyMain.h
 * Purpose:   Defines Application Frame
 * Author:    Qumbetlian (qumbetlian@yahoo.com)
 * Created:   2007-09-20
 * Copyright: Qumbetlian (www.qumbetlian.3x.ro)
 * License:   GPL
 **************************************************************/

#ifndef QCOPYMAIN_H
#define QCOPYMAIN_H

//(*Headers(WFExistDialog)
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/statbmp.h>
#include <wx/stattext.h>
//*)

//(*Headers(qcopyDialog)
#include <wx/gauge.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/textctrl.h>
//*)

#define CONTINUECOPY 1
#define OVERWRITE 0

class gaugeFillingEvent;

class WFExistDialog: public wxDialog
{
	public:

		WFExistDialog(wxWindow* parent, char* fileName, wxWindowID id=wxID_ANY);
		virtual ~WFExistDialog();
		void OnContinue(wxCommandEvent& event);
		void OnOverwrite(wxCommandEvent& event);

	protected:

        //(*Declarations(WFExistDialog)
		wxStaticText* StaticText;
		wxButton* Continue;
		wxButton* Overwrite;
		wxStaticBitmap* StaticBitmap1;

		//(*Identifiers(WFExistDialog)
		static const long ID_STATICTEXT;
		static const long ID_CONTINUE;
		static const long ID_OVERWRITE;
		static const long ID_STATICBITMAP1;
		//*)
};

class qcopyDialog : public wxDialog
{
    public:

        qcopyDialog(wxWindow* parent, wxWindowID id = -1);
        virtual ~qcopyDialog();

    private:

        //(*UserVariables(qcopyDialog)
        char *srcFileName, *destFileName;
        wxWindow* qcopyDialog_;
        wxSemaphore *semaphore1;

        //(*Handlers(qcopyDialog)
        void OnQuit(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnChoiceSrc(wxCommandEvent& event);
        void OnChoiceDest(wxCommandEvent& event);
        void OnCopy(wxCommandEvent& event);
        void OnCancel(wxCommandEvent& event);
        void OnGaugeFilling(gaugeFillingEvent& event);
        //*)

        //(*Identifiers(qcopyDialog)
        static const long ID_PANEL1;
        static const long ID_GAUGE1;
        static const long ID_STATICTEXT1;
        static const long ID_STATICTEXT2;
        static const long ID_COPY;
        static const long ID_STATICTEXT3;
        static const long ID_SPINCTRL;
        static const long ID_CANCEL;
        static const long ID_TEXTCTRLSRC;
        static const long ID_CHOICESRC;
        static const long ID_TEXTCTRLDEST;
        static const long ID_CHOICEDEST;
        static const long ID_ABOUT;
        //*)

        //(*Declarations(qcopyDialog)
        wxBoxSizer* BoxSizer1;
        wxPanel* Panel1;
        wxGauge* Gauge1;
        wxStaticText* StaticText1;
        wxStaticText* StaticText2;
        wxButton* Copy;
        wxStaticText* StaticText3;
        wxSpinCtrl* SpinCtrl;
        wxButton* Cancel;
        wxTextCtrl* TextCtrlSrc;
        wxButton* ChoiceSrc;
        wxTextCtrl* TextCtrlDest;
        wxButton* ChoiceDest;
        wxButton* About;
        //*)

        DECLARE_EVENT_TABLE()
};

#endif // QCOPYMAIN_H
