/***************************************************************
 * Name:      qcopyApp.cpp
 * Purpose:   Code for Application Class
 * Author:    Qumbetlian (qumbetlian@yahoo.com)
 * Created:   2007-09-20
 * Copyright: Qumbetlian (www.qumbetlian.3x.ro)
 * License:   GPL
 **************************************************************/

#include "qcopyApp.h"
#include "qcopyMain.h"

//(*AppHeaders
#include <wx/image.h>
#include <wx/log.h>
//*)

IMPLEMENT_APP(qcopyApp);

bool qcopyApp::OnInit()
{
    //(*AppInitialize
    bool wxsOK = true;
    const wxString appName = wxString::Format("Qcopy-%s", wxGetUserId().c_str());
    appMutex = new wxSingleInstanceChecker(appName);
    if(appMutex->IsAnotherRunning())
    {
        wxLogError(_("Another program instance is already running"));
        delete appMutex;
        return false;
    }
    wxInitAllImageHandlers();
    if ( wxsOK )
    {
        qcopyDialog Dlg(0);
        SetTopWindow(&Dlg);
        Dlg.ShowModal();
        wxsOK = false;
    }
    //*)
    delete appMutex;
    return wxsOK;
}

int qcopyApp::OnExit()
{
    return 0;
}
