/***************************************************************
 * Name:      qcopyMain.h
 * Purpose:   Defines Application Frame
 * Author:    Qumbetlian (qumbetlian@yahoo.com)
 * Created:   2007-09-20
 * Copyright: Qumbetlian (www.qumbetlian.3x.ro)
 * License:   GPL
 **************************************************************/

#ifndef COPYTHREAD_H
#define COPYTHREAD_H

#include "qcopyMain.h"

//(*Headers(gaugeFillingEvent)
#include <wx/event.h>
//*)

//(*Headers(copyThread)
#include <wx/thread.h>
//*)

#define RUNNING 0
#define FINISHED 1
#define STOPPED -1

extern const wxEventType myEVT_GAUGE_FILLING_CHANGE;

class gaugeFillingEvent : public wxEvent
{
    private:
        unsigned int fillingDegree;
        int status;

    public:
        gaugeFillingEvent(unsigned int filling_arg = 0, int ID = 0, wxEventType commandType = myEVT_GAUGE_FILLING_CHANGE)
        : wxEvent(ID, commandType)
        {
            fillingDegree = filling_arg;
            status = RUNNING;
            m_propagationLevel = 2;
        }
        gaugeFillingEvent(const gaugeFillingEvent &event) : wxEvent(event)
        {
            fillingDegree = event.fillingDegree;
            status = event.status;
            m_propagationLevel =2;
        }
        virtual wxEvent *Clone() const
        {
            return new gaugeFillingEvent(*this);
        }
        void setFillingDegree(unsigned int filing)
        {
            fillingDegree = filing;
        }
        unsigned int getFillingDegree()
        {
            return fillingDegree;
        }
        void setStatus(int condition)
        {
            status = condition;
        }
        int getStatus()
        {
            return status;
        }
};

typedef void(wxEvtHandler::*gaugeFillingEventFunction)(gaugeFillingEvent &);

#define myGaugeEventHandler(func)                                           \
	(wxObjectEventFunction)(wxEventFunction)(wxCommandEventFunction)        \
	wxStaticCastEvent(gaugeFillingEventFunction, &func)

/*#define EVT_GAUGE_FILLING_CHANGE(ID, func)                                  \
	DECLARE_EVENT_TABLE_ENTRY(myEVT_GAUGE_FILLING_CHANGE, ID, wxID_ANY,     \
	(wxObjectEventFunction)(wxEventFunction)(wxCommandEventFunction)        \
	wxStaticCastEvent(gaugeFillingEventFunction, &func ), (wxObject*) NULL),*/

class copyThread : public wxThread
{
    private:
        bool continuation;
        char *srcFileName, *destFileName;
        int resolution;
        wxSemaphore *semaphore1;
        gaugeFillingEvent gfevent;
        qcopyDialog *parent;

    public:
        copyThread(qcopyDialog *, const char *, const char *, int, bool, wxSemaphore *);
        ~copyThread();
        void* Entry();
        void OnExit();
};

#endif
