/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TREEVIEWDICT_H
#define TREEVIEWDICT_H
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/liststore.h>
#include "config.hh"
#include "../config.h"

#if !defined(GLADEMM_DATA)
#define GLADEMM_DATA
#include <gtkmm/accelgroup.h>
#include <stdio.h>

class GlademmData
{

        Glib::RefPtr<Gtk::AccelGroup> accgrp;
public:

        GlademmData(Glib::RefPtr<Gtk::AccelGroup> ag) : accgrp(ag)
        {
        }

        Glib::RefPtr<Gtk::AccelGroup>  getAccelGroup()
        {  return accgrp;
        }
};
#endif //GLADEMM_DATA

bool operator > (Glib::ustring& left_str, Glib::ustring right_str);
bool operator < (Glib::ustring& left_str, Glib::ustring right_str);
bool operator >= (Glib::ustring& left_str, Glib::ustring right_str);
bool operator <= (Glib::ustring& left_str, Glib::ustring right_str);

class TreeViewDict : public Gtk::TreeView
{
		char *list_name, *lang1_lang2_list_name, *lang2_lang1_list_name;
		unsigned int lang1_lang2_nitems, lang2_lang1_nitems, *nitems;
	protected:
		struct List
		{
			bool lang1_lang2_saved;
			bool lang2_lang1_saved;
			bool *saved;
		}list;
		class Gtk::TreeView *treeview1;
		class MyModelColumns : public Gtk::TreeModel::ColumnRecord
		{
			public:
				Gtk::TreeModelColumn<Glib::ustring> key_text, val_text;
				MyModelColumns();
				~MyModelColumns();
		} model;
		Gtk::TreeModel::Path path;
		Gtk::TreeModel::iterator iter;
		Glib::RefPtr<Gtk::ListStore> refliststore_lang1_lang2, refliststore_lang2_lang1, *refliststore;
		char* load_list(char* file_name, unsigned int *arg_nitems, Glib::RefPtr<Gtk::ListStore> *arg_refliststore);
		Gtk::TreePath& lookup(Glib::ustring &str, unsigned int lim_up, unsigned int lim_down);
		Gtk::TreePath& establish(Glib::ustring &str, unsigned int lim_up, unsigned int lim_down);
	public:
		TreeViewDict(GlademmData *gmm_data);
		~TreeViewDict();
		void lang1_lang2_select(bool show = true);
		void lang2_lang1_select(bool show = true);
		void set_path(Gtk::TreePath l_path);
		void on_grab_focus();
		bool need_save(void);
		bool remove_word(Gtk::TreePath& path);
		char* save_list(const char* path);
		char* load_lists(const char* path);
		unsigned int get_number_of_items(int arg = 0);
		Glib::ustring get_key(Gtk::TreeModel::Row row);
		Glib::ustring get_value(Gtk::TreeModel::Row row);
		Gtk::TreePath& position_word(Glib::ustring &str);
		Gtk::TreePath& add_word(Glib::ustring k, Glib::ustring v, Glib::ustring mod);
		friend bool operator > (Glib::ustring& left_str, Glib::ustring right_str);
		friend bool operator < (Glib::ustring& left_str, Glib::ustring right_str);
		friend bool operator >= (Glib::ustring& left_str, Glib::ustring right_str);
		friend bool operator <= (Glib::ustring& left_str, Glib::ustring right_str);
};

#endif
