/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //
#include "config.hh"
#include "../config.h"
/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (GETTEXT_PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif
#include <gtkmmconfig.h>
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#include <sigc++/compatibility.h>
#define GMM_GTKMM_22_24(a,b) b
#else //gtkmm 2.2
#define GMM_GTKMM_22_24(a,b) a
#endif //
#include "toolbar2_glade.hh"
#include <gdk/gdkkeysyms.h>
#include <gtkmm/accelgroup.h>
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#endif //

toolbar2_glade::toolbar2_glade(GlademmData *gmm_data
) : Gtk::Toolbar()
{  toolbar2 = this;
   button10 = Gtk::manage(new class Gtk::Button(_("Ă")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem10 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button11 = Gtk::manage(new class Gtk::Button(_("ă")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem11 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button12 = Gtk::manage(new class Gtk::Button(_("Â")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem12 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button13 = Gtk::manage(new class Gtk::Button(_("â")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem13 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button14 = Gtk::manage(new class Gtk::Button(_("Î")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem14 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button15 = Gtk::manage(new class Gtk::Button(_("î")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem15 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button16 = Gtk::manage(new class Gtk::Button(_("Ş")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem16 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button17 = Gtk::manage(new class Gtk::Button(_("ş")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem17 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button18 = Gtk::manage(new class Gtk::Button(_("Ţ")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem18 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   button19 = Gtk::manage(new class Gtk::Button(_("ţ")));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem19 = Gtk::manage(new class Gtk::ToolItem());
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem10);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button10));

   Gtk::Widget *toolitem10 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem11);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button11));

   Gtk::Widget *toolitem11 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem12);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button12));

   Gtk::Widget *toolitem12 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem13);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button13));

   Gtk::Widget *toolitem13 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem14);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button14));

   Gtk::Widget *toolitem14 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem15);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button15));

   Gtk::Widget *toolitem15 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem16);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button16));

   Gtk::Widget *toolitem16 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem17);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button17));

   Gtk::Widget *toolitem17 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem18);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button18));

   Gtk::Widget *toolitem18 = toolbar2->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar2->append(*toolitem19);
#else //
   toolbar2->tools().push_back(Gtk::Toolbar_Helpers::Element(*button19));

   Gtk::Widget *toolitem19 = toolbar2->tools().back().get_widget();
#endif //
   button10->set_name("button10");
   button10->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button10, _("Ctrl + Shift + a"), "");
   button10->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_a, Gdk::CONTROL_MASK | Gdk::SHIFT_MASK, Gtk::ACCEL_VISIBLE);
   button10->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem10->set_name("toolitem10");
   toolitem10->set_visible_horizontal(true);
   toolitem10->set_visible_vertical(true);
   toolitem10->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem10->add(*button10);
#endif //
   button11->set_name("button11");
   button11->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button11, _("Ctrl + a"), "");
   button11->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_a, Gdk::CONTROL_MASK, Gtk::ACCEL_VISIBLE);
   button11->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem11->set_name("toolitem11");
   toolitem11->set_visible_horizontal(true);
   toolitem11->set_visible_vertical(true);
   toolitem11->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem11->add(*button11);
#endif //
   button12->set_name("button12");
   button12->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button12, _("Alt + Shift + a"), "");
   button12->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_a, Gdk::SHIFT_MASK | Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button12->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem12->set_name("toolitem12");
   toolitem12->set_visible_horizontal(true);
   toolitem12->set_visible_vertical(true);
   toolitem12->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem12->add(*button12);
#endif //
   button13->set_name("button13");
   button13->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button13, _("Alt + a"), "");
   button13->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_a, Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button13->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem13->set_name("toolitem13");
   toolitem13->set_visible_horizontal(true);
   toolitem13->set_visible_vertical(true);
   toolitem13->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem13->add(*button13);
#endif //
   button14->set_name("button14");
   button14->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button14, _("Alt + Shift + i"), "");
   button14->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_i, Gdk::SHIFT_MASK | Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button14->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem14->set_name("toolitem14");
   toolitem14->set_visible_horizontal(true);
   toolitem14->set_visible_vertical(true);
   toolitem14->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem14->add(*button14);
#endif //
   button15->set_name("button15");
   button15->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button15, _("Alt + i"), "");
   button15->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_i, Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button15->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem15->set_name("toolitem15");
   toolitem15->set_visible_horizontal(true);
   toolitem15->set_visible_vertical(true);
   toolitem15->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem15->add(*button15);
#endif //
   button16->set_name("button16");
   button16->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button16, _("Alt + Shift + s"), "");
   button16->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_s, Gdk::SHIFT_MASK | Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button16->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem16->set_name("toolitem16");
   toolitem16->set_visible_horizontal(true);
   toolitem16->set_visible_vertical(true);
   toolitem16->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem16->add(*button16);
#endif //
   button17->set_name("button17");
   button17->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button17, _("Alt + s"), "");
   button17->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_s, Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button17->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem17->set_name("toolitem17");
   toolitem17->set_visible_horizontal(true);
   toolitem17->set_visible_vertical(true);
   toolitem17->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem17->add(*button17);
#endif //
   button18->set_name("button18");
   button18->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button18, _("Alt + Shift + t"), "");
   button18->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_t, Gdk::SHIFT_MASK | Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button18->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem18->set_name("toolitem18");
   toolitem18->set_visible_horizontal(true);
   toolitem18->set_visible_vertical(true);
   toolitem18->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem18->add(*button18);
#endif //
   button19->set_name("button19");
   button19->set_flags(Gtk::CAN_FOCUS);
   _tooltips.set_tip(*button19, _("Alt + t"), "");
   button19->add_accelerator("clicked", gmm_data->getAccelGroup(), GDK_t, Gdk::MOD1_MASK, Gtk::ACCEL_VISIBLE);
   button19->set_relief(Gtk::RELIEF_NONE);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem19->set_name("toolitem19");
   toolitem19->set_visible_horizontal(true);
   toolitem19->set_visible_vertical(true);
   toolitem19->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem19->add(*button19);
#endif //
   toolbar2->set_name("toolbar2");
   toolbar2->set_tooltips(true);
   toolbar2->set_toolbar_style(Gtk::TOOLBAR_TEXT);
   toolbar2->set_orientation(Gtk::ORIENTATION_HORIZONTAL);
   button10->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem10->show();
#endif //
   button11->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem11->show();
#endif //
   button12->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem12->show();
#endif //
   button13->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem13->show();
#endif //
   button14->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem14->show();
#endif //
   button15->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem15->show();
#endif //
   button16->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem16->show();
#endif //
   button17->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem17->show();
#endif //
   button18->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem18->show();
#endif //
   button19->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem19->show();
#endif //
   toolbar2->show();
}

toolbar2_glade::~toolbar2_glade()
{
}
