/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QDICT_MENU1_HH
#  define QDICT_MENU1_HH

#if !defined(GLADEMM_DATA)
#define GLADEMM_DATA
#include <gtkmm/accelgroup.h>

class GlademmData
{

		Glib::RefPtr<Gtk::AccelGroup> accgrp;
	public:
		GlademmData(Glib::RefPtr<Gtk::AccelGroup> ag) : accgrp(ag)
		{
        }

		Glib::RefPtr<Gtk::AccelGroup>  getAccelGroup()
		{  return accgrp;
		}
};
#endif //GLADEMM_DATA

#include <gtkmm/menu.h>
#include <gtkmm/image.h>
#include <gtkmm/menuitem.h>
#include <gtkmm/fontselection.h>
#include <gtkmm/imagemenuitem.h>
#include <gtkmm/checkmenuitem.h>

class QdictMenu1 : public Gtk::Menu
{
        class Gtk::Menu *menu1;
        class Gtk::Image *image10;
        class Gtk::ImageMenuItem *select_font;
        class Gtk::CheckMenuItem *modify_words_lists;
        class Gtk::MenuItem *separator3, *submenu1_item;
        class Gtk::RadioMenuItem *radioButton1;
        class Gtk::FontSelectionDialog *font_selection_dialog;
		class Gtk::Window *parent;
		Gtk::RadioMenuItem::Group dictionary;
		Glib::ustring font_name;
	public:
        QdictMenu1(GlademmData *gmm_data, Gtk::Window &arg_parent, const char *arg_font_name);
        ~QdictMenu1();

        //signal accesor.
		typedef SigC::Signal1<void, Glib::ustring> type_signal_font_change;
		type_signal_font_change signal_font_change();
		typedef SigC::Signal1<void, bool> type_signal_modify;
		type_signal_modify signal_modify();
		typedef SigC::Signal0<void> type_signal_dictionary_change;
		type_signal_dictionary_change signal_dictionary_change();
		virtual void font_change();
		virtual void modify();
		void popup(guint button, guint32 activate_time);
	protected:
		type_signal_font_change _signal_font_change;
		type_signal_modify _signal_modify;
		type_signal_dictionary_change _signal_dictionary_change;
        void on_select_font_activate();
        void on_modify_words_lists_activate();
        void on_dictionary_change();
        Gtk::Menu_Helpers::Element::CallSlot dictionary_change;
};
#endif
