/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //
#include "config.hh"
#include "../config.h"
/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (GETTEXT_PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif
#include <gtkmmconfig.h>
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#include <sigc++/compatibility.h>
#define GMM_GTKMM_22_24(a,b) b
#else //gtkmm 2.2
#define GMM_GTKMM_22_24(a,b) a
#endif //
#include "qdict_menu1.hh"
#include "configuration.hh"
#include <gtk/gtkimagemenuitem.h>

QdictMenu1::QdictMenu1(GlademmData *gmm_data, Gtk::Window &arg_parent, const char *arg_font_name){
	menu1 = this;
	font_selection_dialog = NULL;
    parent = &arg_parent;
    font_name = Glib::ustring(arg_font_name);
   	image10 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-select-font"), Gtk::IconSize(1)));
   	select_font = NULL;
   	modify_words_lists = NULL;
   	separator3 = NULL;
   	Gtk::Menu *submenu1 = Gtk::manage(new class Gtk::Menu());
   	radioButton1 = NULL;

   	menu1->items().push_back(Gtk::Menu_Helpers::ImageMenuElem(_("Select font"), *image10));
   	select_font = (Gtk::ImageMenuItem *)&menu1->items().back();

	menu1->items().push_back(Gtk::Menu_Helpers::CheckMenuElem(_("Modify words lists")));
   	modify_words_lists = (Gtk::CheckMenuItem *)&menu1->items().back();

   	menu1->items().push_back(Gtk::Menu_Helpers::SeparatorElem());
   	separator3 = (Gtk::MenuItem *)&menu1->items().back();

   	menu1->items().push_back(Gtk::Menu_Helpers::MenuElem(_("Dictionaries"), *submenu1));
   	submenu1_item = (Gtk::MenuItem *)&menu1->items().back();

   	char *lang = new char[sizeof(char) * (strlen(LANG1_LANG2) + strlen(LANG2_LANG1) + 3)];
   	sprintf(lang, "%s, %s", LANG1_LANG2, LANG2_LANG1);
   	submenu1->items().push_back(Gtk::Menu_Helpers::RadioMenuElem(dictionary, _(lang), dictionary_change));
   	radioButton1 = (Gtk::RadioMenuItem *)&submenu1->items().back();
   	delete[] lang;

   	image10->set_name("image10");
   	image10->set_alignment(0.5,0.5);
   	image10->set_padding(0,0);
   	modify_words_lists->set_active(config().modify());
   	//radioButton1->set_active(config().current.dictionary());
   	menu1->set_name("menu1");
   	image10->show();
   	select_font->show();
   	modify_words_lists->show();
   	separator3->show();
   	radioButton1->show();
   	submenu1->show();
   	menu1->show();
   	select_font->signal_activate().connect(SigC::slot(*this, &QdictMenu1::on_select_font_activate), false);
   	modify_words_lists->signal_activate().connect(SigC::slot(*this, &QdictMenu1::on_modify_words_lists_activate), false);
   	//radioButton1->signal_activate().connect(SigC::slot(*this, &QdictMenu1::on_dictionary_change), false);
}

QdictMenu1::~QdictMenu1(){
	if(font_selection_dialog)
		delete font_selection_dialog;
}

QdictMenu1::type_signal_font_change QdictMenu1::signal_font_change(){
	return _signal_font_change;
}

QdictMenu1::type_signal_modify QdictMenu1::signal_modify(){
	return _signal_modify;
}

QdictMenu1::type_signal_dictionary_change QdictMenu1::signal_dictionary_change(){
	return _signal_dictionary_change;
}

void QdictMenu1::font_change(){
	_signal_font_change.emit(font_name);
}

void QdictMenu1::modify(){
	_signal_modify.emit(config().modify());
}

void QdictMenu1::popup(guint button, guint32 activate_time){
	//radioButton1->set_active(config().current.dictionary());
	Gtk::Menu::popup(button, activate_time);
}

void QdictMenu1::on_select_font_activate(){
	font_selection_dialog = new Gtk::FontSelectionDialog();
	font_selection_dialog->set_transient_for(*parent);
	font_selection_dialog->set_position(Gtk::WIN_POS_CENTER_ON_PARENT);
	font_selection_dialog->set_font_name(font_name);
	if(font_selection_dialog->run() == Gtk::RESPONSE_OK){
		font_name = font_selection_dialog->get_font_name();
		font_change();
	}
	delete font_selection_dialog;
	font_selection_dialog = NULL;
}

void QdictMenu1::on_modify_words_lists_activate(){
	config().set_modify(modify_words_lists->property_active());
	modify();
}

void QdictMenu1::on_dictionary_change(){
	if(radioButton1->property_active())
	_signal_dictionary_change.emit();
}
