/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //

#include <gtkmmconfig.h>
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#include <sigc++/compatibility.h>
#define GMM_GTKMM_22_24(a,b) b
#else //gtkmm 2.2
#define GMM_GTKMM_22_24(a,b) a
#endif //

#include "config.hh"
#include "qdict_help.hh"
#include "images_inline.hh"
#include "qumbetlian_ico_inline.hh"
#include <gdk/gdkkeysyms.h>
#include <gtkmm/accelgroup.h>
#include <gdkmm/pixbufloader.h>
#include <gtkmm/messagedialog.h>

	QdictHelp::QdictHelp()
	{
		qdict_help = this;
		Glib::RefPtr<Gdk::Pixbuf> icon1 = Gdk::Pixbuf::create_from_inline(
			sizeof(qumbetlian_ico_inline), qumbetlian_ico_inline, false);
		closebutton1 = Gtk::manage(new class Gtk::Button(Gtk::StockID("gtk-close")));
		textview1 = Gtk::manage(new class Gtk::TextView());
		scrolledwindow1 = Gtk::manage(new class Gtk::ScrolledWindow());
		Help = Gtk::manage(new class Gtk::Label(Glib::ustring("Help")));
		Glib::ustring about, text1, text2;
	#if defined LINUX_PLATFORM
		about = "Qdict version 2.0 Build for linux with gtk2-2.12.1 and gtkmm24-2.12.0\n\n"
		"This program is offered for free by Alexandru Olaru alias Qumbetlian.\n\nEnjoy of it!\n";
	#else
		about = "Qdict version 2.0 Build for Windows 98, Windows 2000 and Windows XP.\n\n"
		"This program is offered for free by Alexandru Olaru alias Qumbetlian.\n\nEnjoy of it!\n";
	#endif
		label1 = Gtk::manage(new class Gtk::Label(about));
		 label2 = Gtk::manage(new class Gtk::Label(Glib::ustring("Number of words contained in the Ro-En list:  ")));
		 label3 = Gtk::manage(new class Gtk::Label(Glib::ustring("Number of words contained in the En-Ro list:  ")));
		 vbox1 = Gtk::manage(new class Gtk::VBox(false, 0));
		 About = Gtk::manage(new class Gtk::Label(Glib::ustring("About")));
		 label5 = Gtk::manage(new class Gtk::Label(Glib::ustring("")));

		 my_image = Gdk::Pixbuf::create_from_inline(sizeof(my_foto), my_foto, false);
		 image1 = new class Gtk::Image(my_image);

		 label6 = Gtk::manage(new class Gtk::Label(Glib::ustring("Developed by Alexandru Olaru\n"
			"For bug reports and sugestions mail to:\n"
			"qumbetlian@yahoo.com")));
		 vbox2 = Gtk::manage(new class Gtk::VBox(false, 0));
		 Autor = Gtk::manage(new class Gtk::Label(Glib::ustring("Autor")));
		 notebook1 = Gtk::manage(new class Gtk::Notebook());
		 closebutton1->set_flags(Gtk::CAN_FOCUS);
		 closebutton1->set_flags(Gtk::CAN_DEFAULT);
		 closebutton1->set_relief(Gtk::RELIEF_NORMAL);
		 qdict_help->get_action_area()->set_size_request(-1,35);
		 qdict_help->get_action_area()->property_layout_style().set_value(Gtk::BUTTONBOX_SPREAD);
		 textview1->set_flags(Gtk::CAN_FOCUS);
		 textview1->set_editable(true);
		 textview1->set_cursor_visible(true);
		 textview1->set_pixels_above_lines(1);
		 textview1->set_pixels_below_lines(0);
		 textview1->set_pixels_inside_wrap(0);
		 textview1->set_left_margin(4);
		 textview1->set_right_margin(4);
		 textview1->set_indent(0);
		 textview1->set_wrap_mode(Gtk::WRAP_WORD);
		 textview1->set_justification(Gtk::JUSTIFY_LEFT);
		 textview1->get_buffer()->set_text(Glib::ustring("\n"
			 "INTRODUCERE\n"
			 "	Qdict este un dicţionar conceput pentru a putea fi îmbunătăţit de către utilizator. Qdict permite utilizatorului să introducă noi cuvinte, să adauge sensuri noi celor deja existente sau chiar să şteargă anumite cuvinte din lista de cuvinte a dicţionarului. Cuvintele noi introduse vor apare imediat în lista de cuvinte şi vor putea fi găsite la o noua căutare.\n"
			 "\n"
			 "LICENŢA\n"
			 "	Acest program este un software liber, el este distribuit sub Licenţa Publică Generală GNU.\n"
			 "	Înainte de utilizarea acestui program este indicat sa citiţi termenii acestei licenţe.\n"
			 "\n"
			 "INTRODUCEREA DE CUVINTE NOI\n"
			 "	Pentru a putea introduce cuvinte noi în listă sau pentru a modifica pe cele deja existente va trebui ca mai întâi să faceţi disponibile butoanele Add, Delete şi Save din bara de scule. Pentru aceasta, apăsaţi butonul Option şi bifaţi, în meniul care va apare, opţiunea Modify words lists. După această operaţiune butoanele amintite vor deveni accesibile.\n"
			 "	Acum, pentru adăugarea unui cuvânt nou, scrieţi cuvântul dorit în căsuţa editabilă din stânga-sus a ferestrei principale, apăsaţi butonaşul cu semnul = din dreapta căsuţei editabile şi introduceţi definiţia cuvântului în pagina din dreapta ferestrei principale. Apăsaţi butonul Add din bara de scule şi cuvântul va apare în lista de cuvinte a dicţionarului.	listele de cuvinte pot fi salvate imediat apăsând butonul Save. În cazul în care listele de cuvinte au fost modificate şi nu au fost salvate, programul, vă va întreba dacă doriţi să le salvaţi, la închiderea sa.\n"
			 "\n"
			 "MODIFICAREA DEFINIŢIEI UNUI CUVÎNT\n"
			 "	Dacă unul din cuvintele existente în lista dicţionarului nu conţine toate semnificaţiile, se poate adăuga semnificaţia dorită prin editarea definiţiei cuvântului. Pentru a edita definiţia cuvântului dorit, găsiţi cuvântul în lista de cuvinte şi faceţi dublu click pe el pentru a-i afişa definiţia. Apăsaţi butonul = şi veţi putea modifica în pagina din dreapta definiţia cuvântului. La final apăsaţi butonul Add pentru a adăuga cuvântului din listă noua definiţie.\n"
			 "\n"
			 "ŞTERGEREA UNUI CUVÎNT DIN LISTĂ\n"
			 "	Dacă aţi adăugat în lista de cuvinte a dicţionarului un cuvânt scris greşit, acesta poate fi şters din listă, prin marcarea sa cu mouse-ul sau cu ajutorul săgeţilor sus - jos de pe tastatură, apăsând butonul Delete.\n"
			 "\n"
			 "ATENŢIE!\n"
			 "	Programul permite şi ştergerea cuvintelor din lista iniţială de cuvinte, de aceea va rog să fiţi foarte atenţi cu această operaţiune.\n"
			 "	Pentru a nu şterge din greşeală cuvinte sau pentru a nu le modifica involuntar, este recomandat ca opţiunea Modify words lists să fie ţinută dezactivată.\n"
			 "\n"
			 "\n"
			 "LISTA ABREVIERILOR FOLOSITE\n"
			 "\n"
			 "adj. = adjectiv\nadv. = adverb\naux. = auxiliar\nconj. = conjuncţie\ndat. = dativ\nfig. = figurat\ninterj. = interjecţie\nneg. = negativ\nnum. = numeral\npart. = participiu\npl. = plural\npos. = posesiv\nprep. = prepoziţie\npron. = pronume\nsing. = singular\nsf. = substantiv feminin\nsm. = substantiv masculin\nsn. = substantiv neutru\nsup. = superlativ\nv. = verb\nvi. = verb intranzitiv\nvr. = verb reflexiv\nvt. = verb trnzitiv\n"
			 "\n"
			 "MARCAJE FOLOSITE ÎN DEFINIŢIA CUVINTELOR\n"
			 "\n"
			 "~   - înlocuieşte cuvântul definit.\n\n;  - delimitează sensurile cuvântului definit\n\n[]  - încadrează categoria gramaticală pentru care se face definiţia\n\n()  - încadrează explicaţii, precizări suplimentare sau părţi opţionale din cuvânt.\n	Ex.	a semna, a însemna - a (în)semna\n		classic, classical - classic(al)\n\n||  - delimitează un exemplu de folosire a cuvântului respectiv sau expresii cu acelaşi sens ca al cuvântului definit.\n\n//   - se foloseşte împreună cu || şi delimitează propoziţia sau expresia din limba căreia aprţine cuvântul din listă şi traducerea sa în cealaltă limbă.\n"
			 "\n"
			 "P.S.\n"
			 "	Pentru o bună coerenţă a definiţiilor care să facă cât mai clară înţelegerea sensurilor cuvintelor de către toţi utilizatorii dicţionarului, este necesară tratarea în mod unitar a definiţiilor tuturor cuvintelor. De aceea va rog să respectaţi pe cât posibil LISTA ABREVIERILOR şi MARCAJELE pe care le-am stabilit mai sus.\n"
			 ""));
		 scrolledwindow1->set_flags(Gtk::CAN_FOCUS);
		 scrolledwindow1->set_shadow_type(Gtk::SHADOW_IN);
		 scrolledwindow1->set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_AUTOMATIC);
		 scrolledwindow1->property_window_placement().set_value(Gtk::CORNER_TOP_LEFT);
		 scrolledwindow1->add(*textview1);
		 Help->set_alignment(0.5,0.5);
		 Help->set_padding(0,0);
		 Help->set_justify(Gtk::JUSTIFY_LEFT);
		 Help->set_line_wrap(false);
		 Help->set_use_markup(false);
		 Help->set_selectable(false);
		 label1->set_alignment(0.5,0.5);
		 label1->set_padding(0,0);
		 label1->set_justify(Gtk::JUSTIFY_LEFT);
		 label1->set_line_wrap(true);
		 label1->set_use_markup(false);
		 label1->set_selectable(false);
		 label2->set_alignment(0.5,0.5);
		 label2->set_padding(0,0);
		 label2->set_justify(Gtk::JUSTIFY_CENTER);
		 label2->set_line_wrap(false);
		 //label2->set_use_markup(true);
		 label2->set_selectable(false);
		 label3->set_size_request(-1,25);
		 label3->set_alignment(0.5,0.5);
		 label3->set_padding(0,0);
		 label3->set_justify(Gtk::JUSTIFY_CENTER);
		 label3->set_line_wrap(false);
		 label3->set_use_markup(true);
		 label3->set_selectable(false);
		 vbox1->pack_start(*label1);
		 vbox1->pack_start(*label2, Gtk::PACK_SHRINK, 0);
		 vbox1->pack_start(*label3, Gtk::PACK_SHRINK, 0);
		 About->set_alignment(0.5,0.5);
		 About->set_padding(0,0);
		 About->set_justify(Gtk::JUSTIFY_LEFT);
		 About->set_line_wrap(false);
		 About->set_use_markup(false);
		 About->set_selectable(false);
		 label5->set_alignment(0.5,0.5);
		 label5->set_padding(0,0);
		 label5->set_justify(Gtk::JUSTIFY_CENTER);
		 label5->set_line_wrap(false);
		 label5->set_use_markup(false);
		 label5->set_selectable(false);
		 image1->set_alignment(0.5,0.5);
		 image1->set_padding(0,0);
		 label6->set_alignment(0.5,0.1);
		 label6->set_padding(0,0);
		 label6->set_justify(Gtk::JUSTIFY_CENTER);
		 label6->set_line_wrap(false);
		 label6->set_use_markup(false);
		 label6->set_selectable(false);
		 vbox2->pack_start(*label5);
		 vbox2->pack_start(*image1);
		 vbox2->pack_start(*label6);
		 Autor->set_alignment(0.5,0.5);
		 Autor->set_padding(0,0);
		 Autor->set_justify(Gtk::JUSTIFY_LEFT);
		 Autor->set_line_wrap(false);
		 Autor->set_use_markup(false);
		 Autor->set_selectable(false);
		 notebook1->set_size_request(387,329);
		 notebook1->set_flags(Gtk::CAN_FOCUS);
		 notebook1->set_show_tabs(true);
		 notebook1->set_show_border(true);
		 notebook1->set_tab_pos(Gtk::POS_TOP);
		 notebook1->set_scrollable(false);
		 notebook1->append_page(*scrolledwindow1, *Help);
		 notebook1->pages().back().set_tab_label_packing(false, true, Gtk::PACK_START);
		 notebook1->append_page(*vbox1, *About);
		 notebook1->pages().back().set_tab_label_packing(false, true, Gtk::PACK_START);
		 notebook1->append_page(*vbox2, *Autor);
		 notebook1->pages().back().set_tab_label_packing(false, true, Gtk::PACK_START);
		 qdict_help->get_vbox()->set_homogeneous(false);
		 qdict_help->get_vbox()->set_spacing(0);
		 qdict_help->get_vbox()->pack_start(*notebook1);
		 qdict_help->set_title(Glib::ustring("Qdict Help"));
		 qdict_help->set_icon(icon1);
		 qdict_help->set_modal(false);
		 qdict_help->set_type_hint(Gdk::WINDOW_TYPE_HINT_DIALOG);
		 qdict_help->property_window_position().set_value(Gtk::WIN_POS_MOUSE);
		 qdict_help->set_resizable(false);
		 qdict_help->property_destroy_with_parent().set_value(true);
		 qdict_help->set_has_separator(false);
		 qdict_help->add_action_widget(*closebutton1, -7);
		 closebutton1->signal_clicked().connect(SigC::slot(*this, &QdictHelp::on_close));
	}

	QdictHelp::~QdictHelp()
	{
	}

	void QdictHelp::on_close(void){
			hide();
	}

	int QdictHelp::run(Pango::FontDescription fd, const char *lang1_lang2,
											unsigned int lang1_lang2_nitems, const char *lang2_lang1,
											unsigned int lang2_lang1_nitems){
		 char str[strlen(lang1_lang2)*sizeof(char) + 82];
		 textview1->modify_font(fd);
		 sprintf(str, "Number of words contained in the %s list:  <b>%u</b>",
		 lang1_lang2, lang1_lang2_nitems);
		 Glib::ustring text(str);
		 label2->set_text(text);
		 label2->set_use_markup(true);
		 sprintf(str, "Number of words contained in the %s list:  <b>%u</b>",
		 lang2_lang1, lang2_lang1_nitems);
		 text = str;
		 label3->set_text(text);
		 label3->set_use_markup(true);
		 closebutton1->show();
		 textview1->show();
		 scrolledwindow1->show();
		 Help->show();
		 label1->show();
		 label2->show();
		 label3->show();
		 vbox1->show();
		 About->show();
		 label5->show();
		 image1->show();
		 label6->show();
		 vbox2->show();
		 Autor->show();
		 notebook1->show();
		 qdict_help->show();
		 //return(qdict_help->run());
		 return(Gtk::RESPONSE_CLOSE);
	}
