/***************************************************************************
*   Copyright (C) 2006 by Alexandru Olaru                                 *
*   qumbetlian@yahoo.com                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "mainwindow.hh"

#include <gtkmm/main.h>
#include <libintl.h>
#if defined WINDOWS_PLATFORM
#	include <windows.h>
#	include <winbase.h>
#	include <dir.h>
#endif
#if defined LINUX_PLATFORM
#	include <sys/dir.h>
# include <signal.h>
#endif

#if !defined MAX_PATH
#	define MAX_PATH 256
#endif

mainwindow *mainwindow;
#if defined LINUX_PLATFORM
void present(int sig);
#endif

int main(int argc, char **argv)
{
#if defined(ENABLE_NLS)
    #if !defined PACKAGE_LOCALE_DIR
        #define PACKAGE_LOCALE_DIR "$(prefix)/$(DATADIRNAME)/locale"
    #endif
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif //ENABLE_NLS
    Gtk::Main m(&argc, &argv);
#if defined LINUX_PLATFORM
        if(!strcmp(*argv + strlen(*argv) - 5, "qdict")){
#else
        if(!strcmp(*argv + strlen(*argv) - 9, "qdict.exe")){
#endif
        char path_file[MAX_PATH];
        memset(path_file, '\0', MAX_PATH);
#if defined LINUX_PLATFORM
        if(readlink("/proc/self/exe", path_file, MAX_PATH) == -1){
#else
        CreateMutex(NULL, FALSE, "Qdict");
        if(GetLastError() == ERROR_ALREADY_EXISTS)
            exit(0);  // Qdict is already running.
        HMODULE moduleHandle = GetModuleHandle(NULL);
        if(moduleHandle != (HMODULE)0)
            GetModuleFileName(moduleHandle, path_file, MAX_PATH);
        else{
#endif
            char *errmsg = new char[10 + strlen(strerror(errno))];
            sprintf(errmsg, "Getting directory: %s", strerror(errno));
            Glib::ustring msg = errmsg;
#if GTKMM_MINOR_VERSION > 2
            Gtk::MessageDialog msgdlg(msg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
#else
            Gtk::MessageDialog msgdlg(msg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, false, true);
#endif
            msgdlg.set_position(Gtk::WIN_POS_CENTER_ALWAYS);
            msgdlg.run();
            return(0);
        }
#if defined LINUX_PLATFORM
        IPmutex mutex(path_file);
        if(mutex.is_locked()){
            kill(mutex.get_lockingPID(), SIGCHLD);
            exit(0);  // Qdict is already running.
        }
        else
            mutex.lock();
        if(!strcmp(path_file + strlen(path_file) - 5, "qdict")){
#else
        if(!strcmp(path_file + strlen(path_file) - 9, "qdict.exe")){
#endif
#if defined LINUX_PLATFORM
            *(strrchr(path_file, '/')) = '\0';
#else
            *(strrchr(path_file, '\\')) = '\0';
#endif
            try{
                mainwindow = new class mainwindow(path_file);
        #if defined LINUX_PLATFORM
                signal(SIGCHLD, present);
        #endif
                m.run(*mainwindow);
                delete mainwindow;
            }
            catch(mainwindow::stop){
                return(0);
            }
        }
        else {
            Glib::ustring msg = "The length of path to this application is to large.";
#if GTKMM_MINOR_VERSION > 2
            Gtk::MessageDialog msgdlg(msg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
#else
            Gtk::MessageDialog msgdlg(msg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, false, true);
#endif
            msgdlg.set_position(Gtk::WIN_POS_CENTER_ALWAYS);
            msgdlg.run();
        }
    }
    else {
    #if defined LINUX_PLATFORM
        Glib::ustring msg = "The name of this program has been modified.\nPlease rename to back 'qdict' and run again!";
    #else
        Glib::ustring msg = "The name of this program has been modified.\nPlease rename to back 'qdict.exe' and run again!";
    #endif
#if GTKMM_MINOR_VERSION > 2
        Gtk::MessageDialog msgdlg(msg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
#else
        Gtk::MessageDialog msgdlg(msg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, false, true);
#endif
        msgdlg.set_position(Gtk::WIN_POS_CENTER_ALWAYS);
        msgdlg.run();
    }
    return 0;
}
#if defined LINUX_PLATFORM
void present(int sig = SIGCHLD){
    mainwindow->present();
}
#endif
