/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //
#include <gdk/gdkkeysyms.h>
#include <gtkmmconfig.h>

#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#include <sigc++/compatibility.h>
#define GMM_GTKMM_22_24(a,b) b
#else //gtkmm 2.2
#define GMM_GTKMM_22_24(a,b) a
#endif //

#include "config.hh"
#include "../config.h"
#include "qdialog.hh"

qdialog::qdialog(Gtk::Window& parent, const char* title, const char* message, const char* default_button)
{
   qdialog1 = this;
   button_yes = Gtk::manage(new class Gtk::Button(Glib::ustring("Yes")));
   button_no = Gtk::manage(new class Gtk::Button(Glib::ustring("No")));
   question_label = Gtk::manage(new class Gtk::Label(Glib::ustring(message)));
   button_yes->set_name("button_yes");
   button_yes->set_flags(Gtk::CAN_FOCUS);
   button_yes->set_flags(Gtk::CAN_DEFAULT);
   button_yes->set_border_width(2);
   button_yes->set_relief(Gtk::RELIEF_NORMAL);
   button_no->set_name("button_no");
   button_no->set_flags(Gtk::CAN_FOCUS | Gtk::CAN_DEFAULT);
   button_no->set_flags(Gtk::HAS_DEFAULT);
   button_no->set_border_width(2);
   button_no->set_relief(Gtk::RELIEF_NORMAL);
   qdialog1->get_action_area()->set_name("dialog_action_area1");
   qdialog1->get_action_area()->property_layout_style().set_value(Gtk::BUTTONBOX_SPREAD);
   question_label->set_name("question_label");
   question_label->set_alignment(0.5,0.5);
   question_label->set_padding(0,10);
   question_label->set_justify(Gtk::JUSTIFY_CENTER);
   question_label->set_line_wrap(false);
   question_label->set_use_markup(false);
   question_label->set_selectable(false);
   qdialog1->get_vbox()->set_name("qdialog_vbox");
   qdialog1->get_vbox()->set_homogeneous(false);
   qdialog1->get_vbox()->set_spacing(0);
   qdialog1->get_vbox()->pack_start(*question_label);
   qdialog1->set_size_request(280,100);
   qdialog1->set_name("qdialog");
   qdialog1->set_border_width(1);
   qdialog1->set_title(Glib::ustring(title));
   qdialog1->set_modal(true);
   qdialog1->set_transient_for(parent);
   qdialog1->property_window_position().set_value(Gtk::WIN_POS_CENTER_ON_PARENT);
   qdialog1->set_resizable(false);
   qdialog1->property_destroy_with_parent().set_value(false);
   qdialog1->set_has_separator(true);
   qdialog1->set_decorated(true);
   qdialog1->add_action_widget(*button_yes, 0);
   qdialog1->add_action_widget(*button_no, 0);
   qdialog1->set_default_response(NO);
   if(strcmp(default_button, "no"))
      button_yes->grab_default();
   else
      button_no->grab_default();
   button_yes->show();
   button_no->show();
   question_label->show();
   qdialog1->show();
   button_yes->signal_clicked().connect(SigC::slot(*this, &qdialog::on_yes_clicked));
   button_no->signal_clicked().connect(SigC::slot(*this, &qdialog::on_no_clicked));
}

void qdialog::on_yes_clicked(void){
   response(YES);
}

void qdialog::on_no_clicked(void){
   response(NO);
}
