/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //
/*
 * Standard gettext macros.
 */

#include "../config.h"

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (GETTEXT_PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif
#include <gtkmmconfig.h>
#if GTKMM_MAJOR_VERSION == 2 && GTKMM_MINOR_VERSION > 2
#include <sigc++/compatibility.h>
#define GMM_GTKMM_22_24(a,b) b
#else //gtkmm 2.2
#define GMM_GTKMM_22_24(a,b) a
#endif //

#include "toolbar2.hh"
#include "mainwindow.hh"
#include "mainwindow_glade.hh"
#include <gdk/gdkkeysyms.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/radiobutton.h>

mainwindow_glade::mainwindow_glade(
) : Gtk::Window(Gtk::WINDOW_TOPLEVEL)
{  mainwindow = this;
   gmm_data = new GlademmData(get_accel_group());
   image1 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-preferences"), Gtk::IconSize(4)));
   label1 = Gtk::manage(new class Gtk::Label(_("Option")));
   hbox4 = Gtk::manage(new class Gtk::HBox(false, 2));
   alignment1 = Gtk::manage(new class Gtk::Alignment(0.5, 0.5, 0, 0));
   button1 = Gtk::manage(new class Gtk::Button());
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem1 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   image2 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-add"), Gtk::IconSize(4)));
   label2 = Gtk::manage(new class Gtk::Label(_(" Add ")));
   hbox5 = Gtk::manage(new class Gtk::HBox(false, 2));
   alignment2 = Gtk::manage(new class Gtk::Alignment(0.5, 0.5, 0, 0));
   button2 = Gtk::manage(new class Gtk::Button());
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem2 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   image3 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-delete"), Gtk::IconSize(4)));
   label3 = Gtk::manage(new class Gtk::Label(_("Delete")));
   hbox6 = Gtk::manage(new class Gtk::HBox(false, 2));
   alignment3 = Gtk::manage(new class Gtk::Alignment(0.5, 0.5, 0, 0));
   button3 = Gtk::manage(new class Gtk::Button());
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem3 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   image4 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-save"), Gtk::IconSize(4)));
   label4 = Gtk::manage(new class Gtk::Label(_(" Save")));
   hbox7 = Gtk::manage(new class Gtk::HBox(false, 2));
   alignment4 = Gtk::manage(new class Gtk::Alignment(0.5, 0.5, 0, 0));
   button4 = Gtk::manage(new class Gtk::Button());
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem4 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   image5 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-dialog-question"), Gtk::IconSize(4)));
   label5 = Gtk::manage(new class Gtk::Label(_(" Help")));
   hbox8 = Gtk::manage(new class Gtk::HBox(false, 2));
   alignment5 = Gtk::manage(new class Gtk::Alignment(0.5, 0.5, 0, 0));
   button5 = Gtk::manage(new class Gtk::Button());
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem5 = Gtk::manage(new class Gtk::ToolItem());
#endif //
   toolbar1 = Gtk::manage(new class Gtk::Toolbar());

   Gtk::RadioButton::Group _RadioBGroup_radiobutton1;
   radiobutton1 = Gtk::manage(new class Gtk::RadioButton(_RadioBGroup_radiobutton1, _(LANG1_LANG2)));
   radiobutton1->set_size_request(61,-1);
   radiobutton2 = Gtk::manage(new class Gtk::RadioButton(_RadioBGroup_radiobutton1, _(LANG2_LANG1)));
   radiobutton2->set_size_request(61,-1);
   toolbar2 = Gtk::manage(new class toolbar2(gmm_data));
   handlebox1 = Gtk::manage(new class Gtk::HandleBox());
   hbox3 = Gtk::manage(new class Gtk::HBox(false, 0));
   entry1 = Gtk::manage(new class entry1(gmm_data));
   togglebutton1 = Gtk::manage(new class Gtk::ToggleButton(_("=")));
   hbox2 = Gtk::manage(new class Gtk::HBox(false, 0));
   treeviewdict1 = Gtk::manage(new class TreeViewDict(gmm_data));
   scrolledwindow1 = Gtk::manage(new class Gtk::ScrolledWindow());
   vbox2 = Gtk::manage(new class Gtk::VBox(false, 0));
   textview1 = Gtk::manage(new class textview1(gmm_data));
   hbox1 = Gtk::manage(new class Gtk::HBox(false, 0));
   vbox1 = Gtk::manage(new class Gtk::VBox(false, 0));
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar1->append(*toolitem1);
#else //
   toolbar1->tools().push_back(Gtk::Toolbar_Helpers::Element(*button1));

   Gtk::Widget *toolitem1 = toolbar1->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar1->append(*toolitem2);
#else //
   toolbar1->tools().push_back(Gtk::Toolbar_Helpers::Element(*button2));

   Gtk::Widget *toolitem2 = toolbar1->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar1->append(*toolitem3);
#else //
   toolbar1->tools().push_back(Gtk::Toolbar_Helpers::Element(*button3));

   Gtk::Widget *toolitem3 = toolbar1->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar1->append(*toolitem4);
#else //
   toolbar1->tools().push_back(Gtk::Toolbar_Helpers::Element(*button4));

   Gtk::Widget *toolitem4 = toolbar1->tools().back().get_widget();
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolbar1->append(*toolitem5);
#else //
   toolbar1->tools().push_back(Gtk::Toolbar_Helpers::Element(*button5));

   Gtk::Widget *toolitem5 = toolbar1->tools().back().get_widget();
#endif //
   image1->set_name("image1");
   image1->set_alignment(0.5,0.5);
   image1->set_padding(0,0);
   label1->set_name("label1");
   label1->set_alignment(0.5,0.5);
   label1->set_padding(0,0);
   label1->set_justify(Gtk::JUSTIFY_LEFT);
   label1->set_line_wrap(false);
   label1->set_use_markup(false);
   label1->set_selectable(false);
   hbox4->set_name("hbox4");
   hbox4->pack_start(*image1, Gtk::PACK_SHRINK, 0);
   hbox4->pack_start(*label1, Gtk::PACK_SHRINK, 0);
   alignment1->set_name("alignment1");
   alignment1->add(*hbox4);
   button1->set_name("button1");
   button1->set_flags(Gtk::CAN_FOCUS);
   button1->set_relief(Gtk::RELIEF_NONE);
   button1->add(*alignment1);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem1->set_name("toolitem1");
   toolitem1->set_visible_horizontal(true);
   toolitem1->set_visible_vertical(true);
   toolitem1->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem1->add(*button1);
#endif //
   image2->set_name("image2");
   image2->set_alignment(0.5,0.5);
   image2->set_padding(0,0);
   label2->set_name("label2");
   label2->set_alignment(0.5,0.5);
   label2->set_padding(0,0);
   label2->set_justify(Gtk::JUSTIFY_LEFT);
   label2->set_line_wrap(false);
   label2->set_use_markup(false);
   label2->set_selectable(false);
   hbox5->set_name("hbox5");
   hbox5->pack_start(*image2, Gtk::PACK_SHRINK, 0);
   hbox5->pack_start(*label2, Gtk::PACK_SHRINK, 0);
   alignment2->set_name("alignment2");
   alignment2->add(*hbox5);
   button2->set_name("button2");
   button2->set_sensitive(config().modify());
   button2->set_flags(Gtk::CAN_FOCUS);
   button2->set_relief(Gtk::RELIEF_NONE);
   button2->add(*alignment2);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem2->set_name("toolitem2");
   toolitem2->set_visible_horizontal(true);
   toolitem2->set_visible_vertical(true);
   toolitem2->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem2->add(*button2);
#endif //
   image3->set_name("image3");
   image3->set_alignment(0.5,0.5);
   image3->set_padding(0,0);
   label3->set_name("label3");
   label3->set_alignment(0.5,0.5);
   label3->set_padding(0,0);
   label3->set_justify(Gtk::JUSTIFY_LEFT);
   label3->set_line_wrap(false);
   label3->set_use_markup(false);
   label3->set_selectable(false);
   hbox6->set_name("hbox6");
   hbox6->pack_start(*image3, Gtk::PACK_SHRINK, 0);
   hbox6->pack_start(*label3, Gtk::PACK_SHRINK, 0);
   alignment3->set_name("alignment3");
   alignment3->add(*hbox6);
   button3->set_name("button3");
   button3->set_sensitive(config().modify());
   button3->set_flags(Gtk::CAN_FOCUS);
   button3->set_relief(Gtk::RELIEF_NONE);
   button3->add(*alignment3);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem3->set_name("toolitem3");
   toolitem3->set_visible_horizontal(true);
   toolitem3->set_visible_vertical(true);
   toolitem3->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem3->add(*button3);
#endif //
   image4->set_name("image4");
   image4->set_alignment(0.5,0.5);
   image4->set_padding(0,0);
   label4->set_name("label4");
   label4->set_alignment(0.5,0.5);
   label4->set_padding(0,0);
   label4->set_justify(Gtk::JUSTIFY_LEFT);
   label4->set_line_wrap(false);
   label4->set_use_markup(false);
   label4->set_selectable(false);
   hbox7->set_name("hbox7");
   hbox7->pack_start(*image4, Gtk::PACK_SHRINK, 0);
   hbox7->pack_start(*label4, Gtk::PACK_SHRINK, 0);
   alignment4->set_name("alignment4");
   alignment4->add(*hbox7);
   button4->set_name("button4");
   button4->set_sensitive(config().modify());
   button4->set_flags(Gtk::CAN_FOCUS);
   button4->set_relief(Gtk::RELIEF_NONE);
   button4->add(*alignment4);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem4->set_name("toolitem4");
   toolitem4->set_visible_horizontal(true);
   toolitem4->set_visible_vertical(true);
   toolitem4->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem4->add(*button4);
#endif //
   image5->set_name("image5");
   image5->set_alignment(0.5,0.5);
   image5->set_padding(0,0);
   label5->set_name("label5");
   label5->set_alignment(0.5,0.5);
   label5->set_padding(0,0);
   label5->set_justify(Gtk::JUSTIFY_LEFT);
   label5->set_line_wrap(false);
   label5->set_use_markup(false);
   label5->set_selectable(false);
   hbox8->set_name("hbox8");
   hbox8->pack_start(*image5, Gtk::PACK_SHRINK, 0);
   hbox8->pack_start(*label5, Gtk::PACK_SHRINK, 0);
   alignment5->set_name("alignment5");
   alignment5->add(*hbox8);
   button5->set_name("button5");
   button5->set_flags(Gtk::CAN_FOCUS);
   button5->set_relief(Gtk::RELIEF_NONE);
   button5->add(*alignment5);
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem5->set_name("toolitem5");
   toolitem5->set_visible_horizontal(true);
   toolitem5->set_visible_vertical(true);
   toolitem5->set_is_important(false);
#endif //
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem5->add(*button5);
#endif //
   toolbar1->set_name("toolbar1");
   toolbar1->set_tooltips(true);
   toolbar1->set_toolbar_style(Gtk::TOOLBAR_BOTH_HORIZ);
   toolbar1->set_orientation(Gtk::ORIENTATION_HORIZONTAL);
   radiobutton1->set_name("radiobutton1");
   radiobutton1->set_flags(Gtk::CAN_FOCUS);
   radiobutton1->set_border_width(1);
   radiobutton1->set_relief(Gtk::RELIEF_NORMAL);
   radiobutton1->set_mode(true);
   radiobutton1->set_active(true);
   radiobutton2->set_name("radiobutton2");
   radiobutton2->set_flags(Gtk::CAN_FOCUS);
   radiobutton2->set_border_width(1);
   radiobutton2->set_relief(Gtk::RELIEF_NORMAL);
   radiobutton2->set_mode(true);
   radiobutton2->set_active(false);
   handlebox1->set_name("handlebox1");
	 // Latimea barei cu diacritice
   handlebox1->set_size_request(-1,32);
   handlebox1->set_border_width(1);
   handlebox1->set_shadow_type(Gtk::SHADOW_OUT);
   handlebox1->set_handle_position(Gtk::POS_LEFT);
   handlebox1->set_snap_edge(Gtk::POS_TOP);
   handlebox1->add(*toolbar2);
   hbox3->set_name("hbox3");
   hbox3->pack_start(*radiobutton1, Gtk::PACK_SHRINK, 0);
   hbox3->pack_start(*radiobutton2, Gtk::PACK_SHRINK, 0);
   hbox3->pack_start(*handlebox1);
   togglebutton1->set_name("togglebutton1");
   togglebutton1->set_flags(Gtk::CAN_FOCUS);
   togglebutton1->set_relief(Gtk::RELIEF_NONE);
   togglebutton1->set_active(false);
   hbox2->set_name("hbox2");
   hbox2->pack_start(*entry1);
   hbox2->pack_start(*togglebutton1, Gtk::PACK_SHRINK, 0);
   scrolledwindow1->set_name("scrolledwindow1");
   scrolledwindow1->set_flags(Gtk::CAN_FOCUS);
   scrolledwindow1->set_border_width(2);
   scrolledwindow1->set_shadow_type(Gtk::SHADOW_NONE);
   scrolledwindow1->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_ALWAYS);
   scrolledwindow1->property_window_placement().set_value(Gtk::CORNER_TOP_LEFT);
   scrolledwindow1->add(*treeviewdict1);
   vbox2->set_name("vbox2");
   vbox2->pack_start(*hbox2, Gtk::PACK_SHRINK, 0);
   vbox2->pack_start(*scrolledwindow1);
   hbox1->set_name("hbox1");
   hbox1->pack_start(*vbox2);
   hbox1->pack_start(*textview1);
   vbox1->set_name("vbox1");
   vbox1->pack_start(*toolbar1, Gtk::PACK_SHRINK, 0);
   vbox1->pack_start(*hbox3, Gtk::PACK_SHRINK, 0);
   vbox1->pack_start(*hbox1);
   mainwindow->set_name("mainwindow");
   mainwindow->set_title(_("Qdict"));
   mainwindow->set_modal(false);
   mainwindow->property_window_position().set_value(Gtk::WIN_POS_CENTER);
   mainwindow->set_resizable(true);
   mainwindow->property_destroy_with_parent().set_value(false);
   mainwindow->add(*vbox1);
}

mainwindow_glade::~mainwindow_glade()
{  delete gmm_data;
}

void mainwindow_glade::show(void) {
   image1->show();
   label1->show();
   hbox4->show();
   alignment1->show();
   button1->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem1->show();
#endif //
   image2->show();
   label2->show();
   hbox5->show();
   alignment2->show();
   button2->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem2->show();
#endif //
   image3->show();
   label3->show();
   hbox6->show();
   alignment3->show();
   button3->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem3->show();
#endif //
   image4->show();
   label4->show();
   hbox7->show();
   alignment4->show();
   button4->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem4->show();
#endif //
   image5->show();
   label5->show();
   hbox8->show();
   alignment5->show();
   button5->show();
#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
   toolitem5->show();
#endif //
   toolbar1->show();
   radiobutton1->show();
   radiobutton2->show();
   handlebox1->show();
   hbox3->show();
   togglebutton1->show();
   hbox2->show();
   scrolledwindow1->show();
   vbox2->show();
   hbox1->show();
   vbox1->show();
   Gtk::Window::show();
   treeviewdict1->grab_default();
}

entry1_glade::entry1_glade(GlademmData *gmm_data)
{  entry1 = this;
   entry1->set_size_request(120,-1);
   entry1->set_name("entry1");
   entry1->set_flags(Gtk::CAN_FOCUS);
   entry1->set_flags(Gtk::CAN_DEFAULT);
   entry1->grab_focus();
   entry1->set_visibility(true);
   entry1->set_editable(true);
   entry1->set_max_length(26);
   entry1->set_text(_(""));
   entry1->set_has_frame(true);
   entry1->set_activates_default(true);
   entry1->show();
}

entry1_glade::~entry1_glade()
{
}

textview1_glade::textview1_glade(GlademmData *gmm_data)
{  textview1 = this;
   textview1->set_size_request(248,298);
   textview1->set_name("textview1");
   textview1->set_flags(Gtk::CAN_FOCUS);
   textview1->set_border_width(2);
   textview1->set_editable(false);
   textview1->set_cursor_visible(false);
   textview1->set_pixels_above_lines(0);
   textview1->set_pixels_below_lines(0);
   textview1->set_pixels_inside_wrap(0);
   textview1->set_left_margin(0);
   textview1->set_right_margin(0);
   textview1->set_indent(0);
   textview1->set_wrap_mode(Gtk::WRAP_WORD);
   textview1->set_justification(Gtk::JUSTIFY_LEFT);
   textview1->show();
}

textview1_glade::~textview1_glade()
{
}
