/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _MAINWINDOW_HH
#define _MAINWINDOW_HH
#include "mainwindow_glade.hh"
#include "qdialog.hh"
#include "qdict_menu1.hh"
#include "qdict_help.hh"
#include "configuration.hh"
#include <gtkmm/messagedialog.h>
#include <gdk/gdkkeysyms.h>
#include <signal.h>
#if defined LINUX_PLATFORM
#   include <sys/shm.h>
#endif
#define INTERPROCESS_FILE "Qdict-lock"

#if defined ADMINISTRATOR
#define COLABORATOR
#endif

class mainwindow : public mainwindow_glade
{
		bool is_button;
		char *path, *exe_name;
		Glib::RefPtr<Gtk::TreeSelection> refTreeSelection;
		class QdictMenu1 *menu1;
		class Pango::FontDescription fontdescription1;
	protected:
		void on_pressed(void);
		void on_help_clicked(void);
		void on_modify(bool arg_modify);
		void on_font_change(Glib::ustring arg_font);
		bool on_button_release_event(GdkEventButton* event);
		bool on_delete_event(GdkEventAny *ev);
	public:
		class stop{};  //discriminating stop exception class
		mainwindow(char* arg_path);
		~mainwindow();
		void on_add_clicked(void);
		void on_delete_clicked(void);
		void on_save_clicked(void);
		void on_rb1_activate(void);
		void on_rb2_activate(void);
		void on_tb_toggled(void);
		void on_letter_clicked(Gtk::Button*);
		void on_treeview_selection(const Gtk::TreeModel::Path&, Gtk::TreeView::Column*);
		void on_entry_insert_text(const Glib::ustring &str, int *pos);
		void on_entry_delete_text(int start_pos, int end_pos);
};

class entry1 : public entry1_glade
{
	public:
		entry1(GlademmData *gmm_data) : entry1_glade(gmm_data)
		{
		}
};

class textview1 : public textview1_glade
{
	public:
		textview1(GlademmData *gmm_data) : textview1_glade(gmm_data)
		{
		}
};

#if defined LINUX_PLATFORM
	class IPmutex{
		private:
			key_t key;
			pid_t *pid;
			int isms;
		public:
			IPmutex(const char *pathname){
				if((key = ftok(pathname, 'Q')) == -1){
					perror("IPmutex");
					exit(1);
				}
				isms = shmget(key, sizeof(pid_t), 0600 | IPC_CREAT);
				pid = (pid_t *) shmat(isms, (void *) NULL, 0);
				if(pid == (pid_t *)(-1)) {
					perror("IPmutex");
					exit(1);
				}
			}
			~IPmutex(){
				*pid = -1;
				shmdt(pid);
				shmctl(isms, IPC_RMID, NULL);
			}
			void lock(void){
				*pid = getpid();
			}
			void unlock(void){
				*pid = 0;
			}
			bool is_locked(void){
				if(*pid && kill (*pid, 0) == 0)
					return(true);
				else
					return(false);
			}
			pid_t get_lockingPID(void){
				return(*pid);
			}
		};
#endif
#endif
