/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// generated 2006/4/20 17:44:34 EEST by qumbetlian@Fujitsu-Siemens.(none)
// using glademm V2.5.0
//
// newer (non customized) versions of this file go to mainwindow.cc_new

// This file is for your program, I won't touch it again!
#include <gtkmmconfig.h>

#if GTKMM_MAJOR_VERSION==2 && GTKMM_MINOR_VERSION>2
#include <sigc++/compatibility.h>
#define GMM_GTKMM_22_24(a,b) b
#else //gtkmm 2.2
#define GMM_GTKMM_22_24(a,b) a
#endif //

#include <dirent.h>
#include <sys/stat.h>
#include "mainwindow.hh"
#include "qumbetlian_ico_inline.hh"

void mainwindow::on_pressed(void){
     is_button = true;
}

void mainwindow::on_help_clicked(void){
    static QdictHelp qdict_hlp;
    qdict_hlp.run(fontdescription1,
                  LANG1_LANG2, treeviewdict1->get_number_of_items(1),
                  LANG2_LANG1, treeviewdict1->get_number_of_items(2));
}

void mainwindow::on_modify(bool arg_modify){
	button2->property_sensitive() = arg_modify;
	button3->property_sensitive() = arg_modify;
	button4->property_sensitive() = arg_modify;
}

void mainwindow::on_font_change(Glib::ustring arg_font_name){
	config().set_font(arg_font_name.c_str());
	fontdescription1 = Pango::FontDescription(arg_font_name);
	entry1->modify_font(fontdescription1);
	textview1->modify_font(fontdescription1);
	treeviewdict1->modify_font(fontdescription1);
}

bool mainwindow::on_button_release_event(GdkEventButton* event)
{
  if( (event->type == GDK_BUTTON_RELEASE && is_button) && (event->button == 1) )
  {
    menu1->popup(event->button, event->time);
    is_button = false;
    return true;
  }
  else
    return false;
}

bool mainwindow::on_delete_event(GdkEventAny *ev){
	int ans;
	treeviewdict1->lang1_lang2_select(false);
	Glib::ustring usmsg = "The list ";
	usmsg = usmsg + LANG1_LANG2;
	usmsg = usmsg + " has been modified.\nDo you want to save changes of this list?";
	for(int i = 0; i < 2; i++){
		if(treeviewdict1->need_save()){
#if GTKMM_MINOR_VERSION > 2
			Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, false, Gtk::MESSAGE_WARNING, Gtk::BUTTONS_YES_NO, true);
#else
			Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, Gtk::MESSAGE_WARNING, Gtk::BUTTONS_YES_NO, false, true);
#endif
			ans = msgdlg.run();
		}
		else
			ans = Gtk::RESPONSE_NO;
		if(ans == Gtk::RESPONSE_YES){
			char *msg = NULL;
			if(strcmp(msg = treeviewdict1->save_list(config().homePath()), "OK")){
				usmsg = msg;
#if GTKMM_MINOR_VERSION > 2
				Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
#else
				Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, false, true);
#endif
				msgdlg.run();
			}
			if(msg) free(msg);
		}
		treeviewdict1->lang2_lang1_select(false);
		usmsg = "The list ";
		usmsg = usmsg + LANG2_LANG1;
		usmsg = usmsg + " has been modified.\nDo you want to save changes of this list?";
	}
	return(Gtk::Window::on_delete_event(ev));
}

mainwindow::mainwindow(char* arg_path) : mainwindow_glade(){
	path = new char[strlen(arg_path) + 1];
	strcpy(path, arg_path);
#if defined LINUX_PLATFORM
	*(strrchr(path, '/')) = '\0';
#else
	*(strrchr(path, '\\')) = '\0';
#endif
	Glib::RefPtr<Gdk::Pixbuf> icon1 = Gdk::Pixbuf::create_from_inline(
									sizeof(qumbetlian_ico_inline), qumbetlian_ico_inline, false);
	fontdescription1 = Pango::FontDescription(config().font());
	radiobutton1->signal_toggled().connect(SigC::slot(*this, &mainwindow::on_rb1_activate));
	radiobutton2->signal_toggled().connect(SigC::slot(*this, &mainwindow::on_rb2_activate));
	if(radiobutton1->get_active()) on_rb1_activate();
	else on_rb2_activate();
	togglebutton1->signal_toggled().connect(SigC::slot(*this, &mainwindow::on_tb_toggled));
#if GTKMM_MINOR_VERSION > 2
	toolbar2->button10->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button10));
	toolbar2->button11->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button11));
	toolbar2->button12->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button12));
	toolbar2->button13->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button13));
	toolbar2->button14->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button14));
	toolbar2->button15->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button15));
	toolbar2->button16->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button16));
	toolbar2->button17->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button17));
	toolbar2->button18->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button18));
	toolbar2->button19->signal_clicked().connect(sigc::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button19));
#else
	toolbar2->button10->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button10));
	toolbar2->button11->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button11));
	toolbar2->button12->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button12));
	toolbar2->button13->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button13));
	toolbar2->button14->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button14));
	toolbar2->button15->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button15));
	toolbar2->button16->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button16));
	toolbar2->button17->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button17));
	toolbar2->button18->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button18));
	toolbar2->button19->signal_clicked().connect(SigC::bind<Gtk::Button*>(SigC::slot(*this, &mainwindow::on_letter_clicked), toolbar2->button19));
#endif
	button2->signal_clicked().connect(SigC::slot(*this, &mainwindow::on_add_clicked));
	button3->signal_clicked().connect(SigC::slot(*this, &mainwindow::on_delete_clicked));
	button4->signal_clicked().connect(SigC::slot(*this, &mainwindow::on_save_clicked));
	button5->signal_clicked().connect(SigC::slot(*this, &mainwindow::on_help_clicked));
	entry1->signal_insert_text().connect(SigC::slot(*this, &mainwindow::on_entry_insert_text));
	entry1->signal_delete_text().connect(SigC::slot(*this, &mainwindow::on_entry_delete_text));
	entry1->modify_font(fontdescription1);
	treeviewdict1->signal_row_activated().connect(SigC::slot(*this, &mainwindow::on_treeview_selection));
	treeviewdict1->add_accelerator("grab_focus", gmm_data->getAccelGroup(), GDK_Return, Gdk::ModifierType(0), Gtk::ACCEL_VISIBLE);
	textview1->modify_font(fontdescription1);
	treeviewdict1->modify_font(fontdescription1);
//partea de licentiere si autentificare BEGIN
//partea de licentiere si autentificare END
	char *msg = NULL;
	if(strcmp(msg = treeviewdict1->load_lists(config().homePath()), "OK")){
		if(strcmp(msg = treeviewdict1->load_lists(path), "OK")){
			Glib::ustring usmsg = msg;
#if GTKMM_MINOR_VERSION > 2
			Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
#else
			Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, false, true);
#endif
			msgdlg.run();
		}
		char *wordlist_path = new char[sizeof(char) * (strlen(config().homePath()) + strlen(WORDLIST_RELATIVE_PATH) + 1)];
		sprintf(wordlist_path, "%s%s", config().homePath(), WORDLIST_RELATIVE_PATH);
		if(!opendir(wordlist_path))
			if(errno == ENOENT){
#if defined LINUX_PLATFORM
				char *mkdir = "mkdir -p ", *cmd = new char[sizeof(char) *(strlen(wordlist_path) + strlen(mkdir) +1)];
				sprintf(cmd, "%s\"%s\"", mkdir, wordlist_path);
				system(cmd);
				delete[] cmd;
#else
#	if defined WINDOWS_PLATFORM
				char *mkdir = "mkdir ", *cmd = new char[sizeof(char) *(strlen(wordlist_path) + strlen(mkdir) +1)];
				sprintf(cmd, "%s\"%s\"", mkdir, wordlist_path);
				system(cmd);
				delete[] cmd;
#	else error Either LINUX_PLATFORM or WINDOWS_PLATFORM must be defined
#	endif
#endif
			}
			else {
				Glib::ustring msg = strerror(errno);
				msg += Glib::ustring(" ");
				msg += Glib::ustring(wordlist_path);
				Gtk::MessageDialog msgdlg(msg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
			}
		delete[] wordlist_path;
	}
	 mainwindow_glade::mainwindow->set_icon(icon1);
   show();
   is_button = false;
   menu1=new QdictMenu1(gmm_data, *this, config().font());
   menu1->signal_modify().connect(SigC::slot(*this, &mainwindow::on_modify));
   menu1->signal_font_change().connect(SigC::slot(*this, &mainwindow::on_font_change));
   button1->signal_button_release_event().connect(SigC::slot(*this, &mainwindow::on_button_release_event), false);
   button1->signal_pressed().connect(SigC::slot(*this, &mainwindow::on_pressed));
}

mainwindow::~mainwindow(){
	if(path) delete[] path;
	if(exe_name) delete[] exe_name;
	if(menu1) delete menu1;
}

void mainwindow::on_add_clicked(void){
	if(togglebutton1->property_active()){
		if(entry1->get_text() >= "                       " && textview1->get_buffer()->get_text() != ""){
			Gtk::TreePath l_path = treeviewdict1->add_word(entry1->get_text(), textview1->get_buffer()->get_text(), Glib::ustring("insert"));
			togglebutton1->property_active() = false;
			//treeviewdict1->scroll_to_row(l_path);
			treeviewdict1->set_cursor(l_path);
		}
	}
}

void mainwindow::on_delete_clicked(void){
	if(Gtk::TreeModel::iterator iter = treeviewdict1->get_selection()->get_selected()){
		qdialog dialog(*mainwindow_glade::mainwindow, "Delete", "Are you sure you want to delete this word?", "no");
		int result = dialog.run();
		if(result == YES){
			Gtk::TreePath path = treeviewdict1->get_model()->get_path(iter);
			treeviewdict1->remove_word(path);
		}
	}
}

void mainwindow::on_save_clicked(void){
	int ans;
	if(treeviewdict1->need_save()){
		char *smsg = "Do you realy want to save changes of this list?";
		Glib::ustring usmsg = smsg;
#if GTKMM_MINOR_VERSION > 2
		Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, false, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_YES_NO, true);
#else
		Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_YES_NO, false, true);
#endif
		ans = msgdlg.run();
	}
	else
		ans = Gtk::RESPONSE_NO;
	if(ans == Gtk::RESPONSE_YES){
		char *msg = NULL;
		if(strcmp(msg = treeviewdict1->save_list(config().homePath()), "OK")){
			Glib::ustring usmsg = msg;
#if GTKMM_MINOR_VERSION > 2
			Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
#else
			Gtk::MessageDialog msgdlg(*mainwindow_glade::mainwindow, usmsg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, false, true);
#endif
			msgdlg.run();
		}
		if(msg) free(msg);
	}
}

void mainwindow::on_rb1_activate(void){
	entry1->set_text(Glib::ustring(""));
	textview1->get_buffer()->set_text(Glib::ustring(""));
	toolbar2->show_all();
	treeviewdict1->lang1_lang2_select();
}

void mainwindow::on_rb2_activate(void){
	entry1->set_text(Glib::ustring(""));
	textview1->get_buffer()->set_text(Glib::ustring(""));
	toolbar2->hide_all();
	treeviewdict1->lang2_lang1_select();
}

void mainwindow::on_tb_toggled(void){
	if(entry1->get_text() >= "                          "){
		if(togglebutton1->get_active()){
			textview1->property_editable() = true;
			textview1->property_cursor_visible() = true;
			entry1->property_editable() = false;
			radiobutton1->property_sensitive() = false;
			radiobutton2->property_sensitive() = false;
			if(radiobutton2->get_active())
				toolbar2->show_all();
		}
		else{
			textview1->property_editable() = false;
			textview1->property_cursor_visible() = false;
			entry1->property_editable() = true;
			radiobutton1->property_sensitive() = true;
			radiobutton2->property_sensitive() = true;
			if(radiobutton2->get_active())
				toolbar2->hide_all();
			else
				toolbar2->show_all();
		}
	}
	else togglebutton1->property_active() = false;
}
void mainwindow::on_letter_clicked(Gtk::Button *button){
	if(togglebutton1->get_active())
		textview1->get_buffer()->insert_at_cursor(button->get_label());
	else{
		int pos = entry1->get_position();
		Glib::ustring b_label = button->get_label();
		entry1->Gtk::Editable::insert_text(b_label, b_label.bytes(), pos);
		entry1->set_position(pos);
		//on_entry_insert_text(b_label, &pos);
	}
}

void mainwindow::on_treeview_selection(const Gtk::TreeModel::Path& path, Gtk::TreeView::Column* column){
	if(Gtk::TreeModel::iterator iter = treeviewdict1->get_selection()->get_selected()){
		if(togglebutton1->property_active() == true)
			togglebutton1->property_active() = false;
		treeviewdict1->set_path(treeviewdict1->get_model()->get_path(iter));
		entry1->set_text(treeviewdict1->get_key(*iter));
		textview1->get_buffer()->set_text(treeviewdict1->get_value(*iter));
	}
}

void mainwindow::on_entry_insert_text(const Glib::ustring &str, int *pos){
	Gtk::TreePath l_path;
	Glib::ustring entry_str = entry1->get_text();
	/*if(*pos == 1)
		treeviewdict1->set_path(l_path = Gtk::TreePath(Glib::ustring("0")));
	if(*pos < entry_str.length())
		if(treeviewdict1->get_key() >= entry_str)
			l_path = treeviewdict1->lookup_back(entry_str, entry_str.length());
		else
			l_path = treeviewdict1->lookup_forward(entry_str, entry_str.length());
	else
		l_path = treeviewdict1->lookup_forward(entry_str, *pos);*/
	l_path = treeviewdict1->position_word(entry_str);
	treeviewdict1->scroll_to_row(l_path);
	treeviewdict1->set_cursor(l_path);
}

void mainwindow::on_entry_delete_text(int start_pos, int end_pos){
	Gtk::TreePath l_path;
	Glib::ustring entry_str = entry1->get_text();
	if(entry_str == Glib::ustring("")){
		textview1->get_buffer()->set_text(Glib::ustring(""));
		return;
	}
	/*if(treeviewdict1->get_key() >= entry_str)
		l_path = treeviewdict1->lookup_back(entry_str, entry_str.length());
	else
		l_path = treeviewdict1->lookup_forward(entry_str, entry_str.length());*/
	l_path = treeviewdict1->position_word(entry_str);
	treeviewdict1->scroll_to_row(l_path);
	treeviewdict1->set_cursor(l_path);
}
