/***************************************************************************
 *   Copyright (C) 2006 by Alexandru Olaru                                 *
 *   qumbetlian@yahoo.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#if !defined _CONFIGURATION_HH
#define _CONFIGURATION_HH

class Configuration& config(void);

class Configuration
{
		bool m_optionModify;
		char *m_processFileName, *m_configFileName, *m_homePath;
		struct Option
		{
			char *m_optionName, *m_optionValue;
		} m_font, m_modify, m_current_dictionary;
		Configuration();
		~Configuration();
		void establishConfigElements();
		void write(void);
		void createDirIfNotExist(const char *);
		bool read(struct Option &option);
		bool GetCurrentProcessFileName(char *pathName);
		friend Configuration& config(void);
	public:
		const char* processFileName(void);
		const char* configFileName(void);
		const char* homePath(void);
		const char* font(void);
		void set_font(const char* fontName);
		const char* current_dictionary(void);
		void set_current_dictionary(const char* dictionary);
		bool modify(void);
		void set_modify(bool modify);
};
#endif
