; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppId=Qdict
AppName=Qdict
AppVersion=2.0
VersionInfoVersion=2.0
AppVerName=Qdict 2.0
AppPublisher=Qumbetlian
AppPublisherURL=http://www.qumbetlian.3x.ro
AppSupportURL=http://www.qumbetlian.3x.ro
AppUpdatesURL=http://www.qumbetlian.3x.ro
AppCopyright=Copyright  2006 Alexandru Olaru
DefaultDirName={pf}\Qdict
DefaultGroupName=Qdict
AppMutex=Qdict
AllowNoIcons=yes
LicenseFile=COPYING
Compression=zip
SolidCompression=yes
UninstallStyle=modern
AlwaysShowDirOnReadyPage=yes

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "D:\Kits\Development souite\gtk-2.10.11-win32-1.exe"; Destdir: "{tmp}"; CopyMode: dontcopy
Source: "D:\Kits\Development souite\gtkmm-win32-runtime-2.10.11-1.exe"; Destdir: "{tmp}"; CopyMode: dontcopy
Source: "src\qdict.exe"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "share\*"; DestDir: "{app}\share"; CopyMode: alwaysskipifsameorolder; Flags: ignoreversion recursesubdirs
Source: "COPYING"; Destdir: "{app}"
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\Qdict"; Filename: "{app}\bin\qdict.exe"
Name: "{group}\Uninstall"; Filename: "{app}\unins000.exe"
Name: "{userdesktop}\Qdict"; Filename: "{app}\bin\qdict.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Qdict"; Filename: "{app}\bin\qdict.exe"; Tasks: quicklaunchicon

[Run]
Filename: "{app}\bin\qdict.exe"; Description: "{cm:LaunchProgram,Qdict}"; Flags: nowait postinstall

[Registry]
Root: HKCU; Subkey: "Software\Qdict"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\Qdict"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\Qdict"; ValueType: string; ValueName: "Path"; ValueData: "{app}"

[Code]
const
  MB_ICONASTERISK	= 64;
  MB_ICONERROR = 16;
  MB_ICONEXCLAMATION =48;
  MB_ICONINFORMATION = 40;
  MB_ICONQUESTION = 32;
  MB_ICONWARNING = 48;

var
  myProgChecked, myProgCheckAns: boolean;

function MyProgCheck(): Boolean;
begin
  if not myProgChecked then begin
    myProgChecked := true;
    myProgCheckAns := true;
    if CheckForMutexes('Qdict Setup') then begin
      MsgBox('Setup has detected that an other instance of Qdict Setup is running.', mbConfirmation, MB_OK or MB_ICONEXCLAMATION);
      Result := false;
      exit;
    end
    CreateMutex('Qdict Setup');
    if RegKeyExists(HKLM, 'SOFTWARE\Qdict') then begin
      myProgCheckAns := MsgBox('Qdict appear to be instaled. Do you want to reinstall it?', mbConfirmation, MB_YESNO) = IDYES;
    end;
  end;
  Result := myProgCheckAns;
end;

function MyCustomPages(_curPage: Integer; _nextClicked: Boolean): Boolean;
var
  next, msgAns, completSetup: boolean;
  curSubPage, execRes: integer;
  version: string;
begin
  if _nextClicked and (_curPage = wpReady) then
    curSubPage := 1;
  while (curSubPage >=1) and (curSubPage <=2) do begin
    case curSubPage of
      1:
        begin
          ScriptDlgPageOpen();
          ScriptDlgPageSetCaption('Installing GTK+ runtime environment');
          ScriptDlgPageSetSubCaption1('In the next step you are ready to install GTK+ runtime environment on your computer.');
          next := OutputMsg('The GTK+ runtime environment is required by the Qdict for running.'#13#13'Klick Next for begining the installation.', true);
          if next then begin
            msgAns := true;
            if RegValueExists(HKLM, 'SOFTWARE\GTK\2.0', 'Version') then begin
              RegQueryStringValue(HKLM, 'SOFTWARE\GTK\2.0', 'Version', Version);
              if CompareText('2.10.11', Version) > 0 then
                MsgBox('Setup has detected an older version of GTK+ runtime environment.'#13#13'A new version will be installing', mbInformation, MB_OK)
              else begin
                MsgBox('A proper version of GTK+ runtime environment has been detected.', mbInformation, MB_OK)
                msgAns := false;
              end;
            end;
              //msgAns := MsgBox('GTK+-runtime is already instaled. Do you want to reinstall it?', mbConfirmation, MB_YESNO) = IDYES;
            if msgAns then begin
              ExtractTemporaryFile('gtk-2.10.11-win32-1.exe');
              ScriptDlgPageSetSubCaption1('');
              OutputMsg('GT+ runtime environment setup is running', false);
                if InstExec(ExpandConstant('{tmp}')+'\gtk-2.10.11-win32-1.exe', '', ExpandConstant('{tmp}'), true, true, 1, execRes) then
                  completSetup := execRes = 0
                else
                  completSetup := false
            end;
          end;
        end;
      2:
        begin
          ScriptDlgPageOpen();
          ScriptDlgPageSetCaption('Installing gtkmm runtime environment');
          ScriptDlgPageSetSubCaption1('In the next step you are ready to install gtkmm runtime environment  on your computer.');
          next := OutputMsg('The gtkmm runtime environment is required by the Qdict for running.'#13#13'Klick Next for begining the installation.', true);
          if next then begin
            msgAns := true;
            if RegValueExists(HKLM, 'SOFTWARE\gtkmm\2.4', 'Version') then begin
              RegQueryStringValue(HKLM, 'SOFTWARE\gtkmm\2.4', 'Version', Version);
              if CompareText('2.10.11', Version) > 0 then
                MsgBox('Setup has detected an older version of gtkmm runtime environment.'#13#13'A new version will be installing', mbInformation, MB_OK)
              else begin
                MsgBox('A proper version of gtkmm runtime environment has been detected.', mbInformation, MB_OK)
                msgAns := false;
              end;
            end;
            if msgAns then begin
              ExtractTemporaryFile('gtkmm-win32-runtime-2.10.11-1.exe');
              ScriptDlgPageSetSubCaption1('');
              OutputMsg('gtkmm runtime rnvironment setup is running', false);
              if InstExec(ExpandConstant('{tmp}')+'\gtkmm-win32-runtime-2.10.11-1.exe', '', ExpandConstant('{tmp}'), true, true, 1, execRes) then
                completSetup := execRes = 0
              else
                completSetup := false
            end;
          end;
        end;
      end;
    if (next and ((msgAns xor completSetup) and msgAns)) then begin
      MainForm.CLOSE;
      curSubPage := curSubPage - 1;
    end;
    if Terminated then break;
    if next then begin
      ScriptDlgPageClose(true);
      curSubPage := curSubPage + 1;
      Result := true;
    end else begin
      if not (curSubPage = 1) then begin
        ScriptDlgPageClose(false);
        curSubPage := curSubPage - 1;
      end;
      Result := false;
    end;
  end;
  Result := true;
end;

function InitializeSetup(): Boolean;
begin
  Result := MyProgCheck();
end;

function NextButtonClick(CurPage: Integer): Boolean;
begin
  Result := MyCustomPages(CurPage, True);
end;

function BackButtonClick(CurPage: Integer): Boolean;
begin
  Result := MyCustomPages(CurPage, False);
end;
